package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.attribute.UniqueKey;
import easik.sketch.attribute.UniqueKeyUI;
import easik.sketch.vertex.EntityNode;


/**
 * Edit unique key popup menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class EditUniqueKeyAction extends AbstractAction {	
	
	/**
	 *	Set up the edit unique key menu option.
	 */
	public EditUniqueKeyAction() {
		super("Edit Unique Key");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Edits the currently selected unique key.");		
	}
	
	/**
	 * Brings up a dialog to edit the currently selected unique key
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		EntityNode curEntity;
		UniqueKey myKey;
		
		//Check what is currently selected
		if(curSelected.getClass() == UniqueKey.class){
			//Entity is selected so set it as current entity
			myKey = (UniqueKey) curSelected;
			curEntity = myKey.getParent();
		}
		else{
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
					"You do not have an entity selected. \nPlease select an entity and try again.",
					"No Entity Selected", JOptionPane.ERROR_MESSAGE);
			return;//Jump out of function
		}
		
		UniqueKeyUI myUI = new UniqueKeyUI(curEntity, myKey);
		if(myUI.getExit())
		{
			//Get values from dialog
			String newKeyName = myUI.getKeyName();
			ArrayList newAttList = myUI.getAttList();
			UniqueKey newKey = new UniqueKey(curEntity, newAttList, newKeyName); //Temporarily used to get id
			
			//Check if attribute name already exists for this entity
			if((newKeyName.equals(myKey.getKeyName()) || !UniqueKey.isKeyNameUsed(curEntity, newKeyName)) &&
					(newAttList.equals(myKey.getAttributes()) || UniqueKey.isKeyUnique(curEntity, newKey.getId()))){
				//Update information
				myKey.setAttributes(newAttList);
				myKey.setKeyName(newKeyName);
				
				//Refresh tree
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(curSelectedNode); //Refresh view of key
				
				Object[] myCell = new Object[1];
				myCell[0] = Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(curEntity);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().hideCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().showCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().repaint();
				
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}
			else{
				//Pop up error dialog
				JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
						"There is already a unique key with that name or attribute list. \nPlease try again.",
						"Unique Key Already Exists", JOptionPane.ERROR_MESSAGE);
			}
		}
	}
}
